/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"
#include <errno.h>

unsigned _RTL_FUNC _dos_getdiskfree(unsigned __drive,struct diskfree_t *__dtable)
{
   char *s=0,buf[4] ;
   DWORD secperclust, bytepersect,availclust,totalclust ;
   strcpy(buf,"@:\\") ;
   if (__drive) {
      buf[0] += __drive ;
      s=buf ;
   }
   if (GetDiskFreeSpace(s,&secperclust,&bytepersect,&availclust,&totalclust)) {
      __dtable->sectors_per_cluster = secperclust ;
      __dtable->bytes_per_sector = bytepersect ;
      __dtable->total_clusters = totalclust ;
      __dtable->avail_clusters = availclust ;
      return 0 ;
   }
   errno=EINVAL ;
   return GetLastError() ;

}
unsigned _RTL_FUNC _getdiskfree(unsigned __drive,struct _diskfree_t *__dtable)
{
	return _dos_getdiskfree( __drive, __dtable);
}
