/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <sys/stat.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include <limits.h>
#include <io.h>
#include "libp.h"

static void format_finddata(struct _finddata_t *buf, LPWIN32_FIND_DATA data)
{
	buf->attrib = 0;
	if (data->dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE)
		buf->attrib |= _A_ARCH ;
	if (data->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		buf->attrib |= _A_SUBDIR ;
	if (data->dwFileAttributes & FILE_ATTRIBUTE_HIDDEN)
		buf->attrib |= _A_HIDDEN ;
	if (data->dwFileAttributes & FILE_ATTRIBUTE_READONLY)
		buf->attrib |= _A_RDONLY ;
	if (data->dwFileAttributes & FILE_ATTRIBUTE_SYSTEM)
		buf->attrib |= _A_SYSTEM ;
	buf->time_access = __to_timet(&data->ftLastAccessTime) ;
	buf->time_write = __to_timet(&data->ftLastWriteTime) ;
	buf->time_create = __to_timet(&data->ftCreationTime) ;
	if (data->nFileSizeHigh)
		*(DWORD *)(&buf->size) = 0xffffffff ;
	else
		*(DWORD *)(&buf->size) = data->nFileSizeLow;
	strcpy(buf->name,data->cFileName);
}
long _RTL_FUNC _findfirst(const char *string, struct _finddata_t *buf)
{
	WIN32_FIND_DATA find_data ;
	HANDLE val ;
	if (!buf)
	{
		errno = EINVAL;
		return 0;
	}
	val = FindFirstFile(string,&find_data);
	memset(buf,0,sizeof(*buf));
	if (val == INVALID_HANDLE_VALUE)
	{
		errno = ENOENT;
		return 0 ;
	}
	format_finddata(buf,&find_data);
	return (int)val;
	
}
int _RTL_FUNC _findnext(long handle, struct _finddata_t *buf)
{
	WIN32_FIND_DATA find_data ;
	if (!buf)
	{
		errno = EINVAL;
		return -1;
	}
	if (!FindNextFile((HANDLE)handle, &find_data)) {
		errno = ENOENT;
		return -1;
	}
	format_finddata(buf,&find_data) ;

	return 0 ;
}
int _RTL_FUNC _findclose(long handle)
{
	FindClose((HANDLE)handle);
	return 0;
}