/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
/*
 * DOS routines to read the number of ticks of the timer used for the int
 * 8 interrupt since the program started (more or less)
 *
 * note: ASSUMES the clock rate is 18.2Hz
 */
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"
#include <windows.h>
  
static unsigned int ticks=0;
static unsigned last_read;

unsigned int _elapsed_time(void)
{
#ifdef XXXXX
	LARGE_INTEGER x;
	QueryPerformanceCounter(&x);
	return x.LowPart;
#endif
	int rv =  __ll_ticks() ;
	int rv1 = last_read ;
	last_read = rv ;
	return rv - rv1 ;
}