/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <sys/stat.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include <limits.h>
#include <io.h>
#include "libp.h"

time_t __to_timet(FILETIME *time)
{
   TIME_ZONE_INFORMATION tzinfo ;
   int bias ;
   SYSTEMTIME stime ;
   struct tm tmx ;
   time_t tempTime;
   int temp = GetTimeZoneInformation(&tzinfo) ;
   if (temp != TIME_ZONE_ID_INVALID)
    bias = tzinfo.Bias ;
   else
    bias = 0 ;
   if (temp == TIME_ZONE_ID_DAYLIGHT)
     bias +=tzinfo.DaylightBias ;
   else
     bias +=tzinfo.StandardBias ;
   FileTimeToSystemTime(time,&stime) ;
   tmx.tm_hour = stime.wHour ;
   tmx.tm_min = stime.wMinute ;
   tmx.tm_sec = stime.wSecond ;
   tmx.tm_mon = stime.wMonth-1 ;
   tmx.tm_mday = stime.wDay ;
   tmx.tm_year = stime.wYear - 1900 ;
   tempTime =  mktime(&tmx) ;
   if (tempTime == (time_t)-1)
	   return tempTime ;
   return tempTime - bias * 60;
}
int __ll_stat(int handle, void *__statbuf)
{
   struct _stat *sb = __statbuf ;
   BY_HANDLE_FILE_INFORMATION info ;
   FILETIME timex ;

   if (sb->st_mode & S_IFCHR)
      return 0 ;

   if (!GetFileInformationByHandle((HANDLE)handle,&info)) {
      errno = EBADF ;
      return -1 ;
   }
   if (sb->st_mode & S_IFREG) {
      sb->st_atime = __to_timet(&info.ftLastAccessTime) ;
      sb->st_mtime = __to_timet(&info.ftLastWriteTime) ;
      sb->st_ctime = __to_timet(&info.ftCreationTime) ;
   } 
	return 0;
}
int __ll_namedstat(const char *file, void *__statbuf)
{
	struct stat *sb = __statbuf;
	WIN32_FIND_DATA finddata;
	HANDLE handle;
	if ((handle = FindFirstFile(file, &finddata)) != INVALID_HANDLE_VALUE)
	{
	  FindClose(handle);
      sb->st_atime = __to_timet(&finddata.ftLastAccessTime) ;
      sb->st_mtime = __to_timet(&finddata.ftLastWriteTime) ;
      sb->st_ctime = __to_timet(&finddata.ftCreationTime) ;

	  if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		sb->st_mode = S_IFDIR;
	  else 
	  	sb->st_mode = S_IFREG;
	  sb->st_mode |= S_IREAD;
	  if (!(finddata.dwFileAttributes & FILE_ATTRIBUTE_READONLY))
		  sb->st_mode |= S_IWRITE;
	  if (!finddata.nFileSizeHigh)
	  {
		  sb->st_size = finddata.nFileSizeLow;
		  return 0;
	  }
	}
	return -1;	
}
