/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdarg.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include <libp.h>
#include <limits.h>
#include <float.h>
#ifdef _i386_
#define USE_FLOAT
#endif


int _RTL_FUNC wscanf(const wchar_t *format, ...)
{
   return __wscanf(stdin,format,((char *)&format+sizeof(wchar_t *)));
}

int _RTL_FUNC vswscanf(wchar_t *restrict buf, const wchar_t *restrict format, 
            va_list list)
{
   int rv ;
   FILE fil ;
   memset(&fil,0,sizeof(fil)) ;
   fil.level = wcslen(buf)*2+2 ;
   fil.flags = _F_IN | _F_READ | _F_BUFFEREDSTRING ;
   fil.bsize = wcslen(buf)*2 ;
   fil.buffer = fil.curp = buf ;
   fil.token = FILTOK ;
   return __wscanf(&fil,format,list);
}
int _RTL_FUNC swscanf(wchar_t *restrict buf, const wchar_t *restrict format, ...)
{
   return vswscanf(buf,format,(((char *)&format)+sizeof(wchar_t *)));
}
int vfwscanf(FILE *restrict fil, const wchar_t *restrict format, va_list arglist)
{
    return __wscanf(fil,format,arglist);
}
int fwscanf(FILE *restrict fil, const wchar_t *restrict format, ...)
{
   return __wscanf(fil,format,((char *)&format+sizeof(wchar_t *)));
}