/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/

#include <errno.h>
#include <wchar.h>

size_t wcsrtombs (char *restrict dst, const wchar_t **restrict src, size_t len, mbstate_t *restrict p)
{
  wchar_t wc;
  size_t used = 0;
  const wchar_t *r = *src;
  (void)p;
  
  if (dst == NULL)
    len = (size_t)-1;

  while (used < len) {
      wc = *r++;

      if (wc == L'\0') {
    	  if (dst != NULL)
	        *dst = '\0';
	      *src = NULL;
    	  return used;
      } else if (wc < 0x80) {
    	  if (dst != NULL)
	        *dst++ = (char) wc;
	      used++;
      }
      else if ((unsigned)wc <= 0x7ff) {
          if (used + 2 <= len) {
              if (dst != NULL) {
                *dst++ = 0xc0 + (wc >> 6) ;
                *dst++ = (wc & 0x3f) | 0x80 ;
            }
            used+=2;
          } else {
            r-- ;
            break;
          }
      } else {
          if (used + 3 <= len) {
              if (dst != NULL) {
                *dst++ = 0xe0 + (wc >> 12) ;
                *dst++ = ((wc >> 6) & 0x3f) | 0x80 ;
                *dst++ = (wc & 0x3f) | 0x80 ;
            }
            used+=3;
          } else {
            r--;
            break;
          }
      }
  }

  *src = r;

  return used;
}
