
/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <wchar.h>
#include <wctype.h>
#include <time.h>
#include <errno.h>
#include <locale.h>
#include <float.h>
#include "_locale.h"
#include "libp.h"

static unsigned floating_infinity = 0x7f800000;
static unsigned floating_nan = 0x7fc00000;

#define nextchar { *ch = fgetwc(fil); \
                    (*chars)++; \
                    if (!count) return val; \
                    else count--; }
                    
long double __xwcstod(FILE *fil, int count, int *ch, int *chars, long double max, int exp2, int exp10, int full)
{
	int sign = 0;
    int fracdigits =0;
	long double val = 0;
	int exp=0;
    int radix = 10;
    wchar_t *bpos = fil->curp;
    
    NUMERIC_DATA *nd = __locale_data[LC_NUMERIC];
    count--;
    while (iswspace(*ch)) nextchar;
        
    if (*ch == '-') {
		sign++;
        nextchar;
	}
    else if (*ch == '+') {
        nextchar;
	}
    if (*ch == '0') {
        nextchar;
        if (*(ch) == 'x' || *(ch) == 'X')  {
            radix = 2;
            nextchar;
        }
    } else if (full && *ch == 'i' || *ch == 'I') {
        int i;
        wchar_t *bpos2;
        nextchar;
         if (*ch != 'n' && *ch != 'N') {
            fil->curp = bpos;
            return 0;
         }
        nextchar;
         if (*ch != 'f' && *ch != 'F') {
            fil->curp = fil->buffer;
            return 0;
         }
         nextchar ;
         bpos2 = fil->curp ;
         for (i=0; i < 5; i++) {
            if ("inity"[i] != (*ch | 0x20)) {
                fil->curp = bpos2;
                break ;
            }
         }
         if (sign)
            return - *(float *)&floating_infinity;
         else
            return *(float *)&floating_infinity;
    } else if (full && *ch == 'n' || *ch == 'N') {
        int shift = 18;
        unsigned nan = floating_nan;
        nextchar;
         if (*ch != 'a' && *ch != 'A') {
            fil->curp = bpos;
            return 0;
         }
        nextchar;
         if (*ch != 'n' && *ch != 'N') {
            fil->curp = bpos;
            return 0;
         }
         nextchar;
         while (isxdigit(*ch) && shift >= 2) {
            int n = *ch;
            nextchar ;
            if (n >= 'a')
                n = n - 'a' + 10;
            else if (n >= 'A')
                n = n - 'A' + 10;
            else
                n = n - '0';
            nan |= n << shift;
            shift -= 4;
         }
         val = *(float *)&nan;
         return val;
    } else if (!isdigit(*ch) && *ch != nd->decimal_point[0]) {
        fil->curp = bpos;
        return 0;
    }
    if (radix == 2) {
        while (isxdigit(*ch)) {
            val = val * 16 ;
            if (*ch <= '9')
                val += *ch - '0';
            else if (*ch >= 'a')
                val += *ch - 'a' + 10;
            else
                val += *ch - 'A' + 10;
            nextchar;
        }
        if (*ch == nd->decimal_point[0]) {
            nextchar;
            while (isxdigit(*ch)) {
                val = val * 16 ;
                if (*ch <= '9')
                    val += *ch - '0';
                else if (*ch >= 'a')
                    val += *ch - 'a' + 10;
                else
                    val += *ch - 'A' + 10;
                nextchar;
                fracdigits += 4;
            }
        }
    	if (sign)
    		val = - val;
        if (*ch == 'p' || *ch == 'P') {
    		sign = 0;
            nextchar;
            if (*ch == '-') {
    			sign++;
                nextchar;
    		}
            else if (*ch == '+') {
                nextchar;
    		}
            while(isdigit(*ch)) {
    			exp*= 10;
                exp += (*ch-'0');
                nextchar;
    		}
    		if (exp > exp2) {
                goto rangeerr;
            }
    		if (sign)
                val = scalbnl(val,-exp-fracdigits);
    		else
                val = scalbnl(val,exp-fracdigits);
    	} else if (fracdigits)
            val = scalbnl(val,-fracdigits);
    } else {
        while (isdigit(*ch)) {
            val = val * 10 + (*ch - '0');
            nextchar;
        }
        if (*ch == nd->decimal_point[0]) {
            nextchar;
            while(isdigit(*ch)) {
                val = val * 10 + (*ch - '0');
                nextchar ;
                fracdigits++;
    	    }
    	}
    	if (sign)
    		val = - val;
        if (*ch == 'e' || *ch == 'E') {
    		sign = 0;
            nextchar;
            if (*ch == '-') {
    			sign++;
                nextchar;
    		}
            else if (*ch == '+') {
                nextchar;
    		}
            while(isdigit(*ch)) {
    			exp*= 10;
                exp += (*ch-'0');
                nextchar;
    		}
    		if (exp > exp10) {
                goto rangeerr;
            }
    		if (sign) {
                exp += fracdigits ;
    			val = val / pow10l(exp);
            } else {
                exp -= fracdigits ;
                if (exp < 0) {
                    exp = - exp;
                }
    			val = val * pow10l(exp);
            }
    	} else if (fracdigits) {
   			val = val / pow10l(fracdigits);
        }
    }
    if (val > max || val < - max) {
rangeerr:
        errno = ERANGE;
        if (max == FLT_MAX)
            return HUGE_VALF; // copysignf(HUGE_VALF,val);
        else if (max == DBL_MAX)
            return HUGE_VAL; // copysign(HUGE_VAL,val);
        else
            return HUGE_VALL; //copysignl(HUGE_VALL,val);
    }
	return val;
}
static long double __wcstod(const wchar_t *buf, wchar_t **endptr, int width,
        long double max,int exp2,int exp10, int full)
{
   long double rv ;
   int ch,chars ;
   FILE fil ;
   memset(&fil,0,sizeof(fil)) ;
   fil.level = wcslen(buf)*2+4 ;
   fil.flags = _F_IN | _F_READ | _F_BUFFEREDSTRING ;
   fil.bsize = wcslen(buf)*2 ;
   fil.buffer = fil.curp = buf ;
   fil.token = FILTOK ;
   ch = fgetwc(&fil) ;
   rv = __xwcstod(&fil,width,&ch,&chars,max,exp2,exp10,full) ;
   if (endptr) {
      *endptr = fil.curp;
      if (fil.curp != fil.buffer)
        (*endptr)--;
   }
   return rv ;
}
long double  _RTL_FUNC wcstold(const wchar_t *restrict string, wchar_t **restrict endptr)
{
   return(__wcstod(string,endptr,256,LDBL_MAX, LDBL_MAX_EXP, LDBL_MAX_10_EXP,1));
}
long double  _RTL_FUNC _wcstold(const wchar_t *restrict string, wchar_t **restrict endptr)
{
    return wcstold(string,endptr);
}
double  _RTL_FUNC wcstod(const wchar_t *restrict string, wchar_t **restrict endptr)
{
   return((double)__wcstod(string,endptr,256,DBL_MAX, DBL_MAX_EXP, DBL_MAX_10_EXP,1));
}
float _RTL_FUNC wcstof(const wchar_t *restrict string, wchar_t ** restrict endptr)
{
   return((float)__wcstod(string,endptr,256,FLT_MAX, FLT_MAX_EXP, FLT_MAX_10_EXP,1));
}
double  _RTL_FUNC wtof(const wchar_t *restrict string)
{
   return((double)__wcstod(string,0,256,DBL_MAX, DBL_MAX_EXP, DBL_MAX_10_EXP,1));
}
long double  _RTL_FUNC _wtold(const wchar_t *restrict string)
{
   return(__wcstod(string,0,256,LDBL_MAX, LDBL_MAX_EXP, LDBL_MAX_10_EXP,1));

}