/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/

#include <errno.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

size_t wcrtomb (char *restrict s, wchar_t wc, mbstate_t *restrict ps)
{
  char xx[1];

  if (s == NULL) {
        return wcrtomb(xx,L'\0',ps);
  }
  if (ps == NULL)
    ps = &__getRtlData()->wcrtomb_st;

  if (wc < 0x80)
    {
      if (s != NULL)
    	*s = (char) wc;
      return 1;
    }

  if ((unsigned) wc <= 0x7ff) {
    if (s != NULL) {
        *s++ = 0xc0 + (wc >> 6) ;
        *s++ = (wc & 0x3f) | 0x80 ;
    }
    return 2;
  }
    if (s != NULL) {
        *s++ = 0xe0 + (wc >> 12) ;
        *s++ = ((wc >> 6) & 0x3f) | 0x80 ;
        *s++ = (wc & 0x3f) | 0x80 ;
      
    }
  return 3;
}
