/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

int _RTL_FUNC __fputwc(int c, FILE *stream)
{
    char cl;
	if (stream->buffer) {
		++stream->level;
		*stream->curp++ = (unsigned char)(c >> 8);
		if (stream->level >= 0) {
			fflush(stream);
			stream->flags &= ~_F_IN;
			stream->flags |= _F_OUT;
			stream->level = -stream->bsize;
			stream->curp = stream->buffer;
        }
		++stream->level;
		*stream->curp++ = (unsigned char)(c);
		if (c == '\n' && (stream->flags & _F_LBUF) || stream->level >=0) {
			fflush(stream);
			stream->flags &= ~_F_IN;
			stream->flags |= _F_OUT;
			stream->level = -stream->bsize;
			stream->curp = stream->buffer;
        }
	}		
	else {
    	char c1 ;
        if (stream->flags & _F_APPEND)
            if (__ll_seek(fileno(stream),0,SEEK_END)) {
                stream->flags |= _F_ERR;
                errno = EIO;
                return WEOF;
            }
		if (!(stream->flags & _F_BIN) && c == '\n') {
            cl = 0;
			if (__ll_write(fileno(stream),&c1,1) < 0) {
				stream->flags |= _F_ERR;
				errno = EIO;
				return WEOF;
			}
            cl = 13;
			if (__ll_write(fileno(stream),&c1,1) < 0) {
				stream->flags |= _F_ERR;
				errno = EIO;
				return WEOF;
			}
		}
        cl = c >> 8;
		if (__ll_write(fileno(stream),&cl,1) < 0) {
			stream->flags |= _F_ERR;
			errno = EIO;
			return WEOF;
		}
        cl = c & 0xff;
		if (__ll_write(fileno(stream),&cl,1) < 0) {
			stream->flags |= _F_ERR;
			errno = EIO;
			return WEOF;
		}
	}
    return c;
}
wint_t _RTL_FUNC fputwc(wchar_t c, FILE *stream)
{
	int rv;
	if (stream->token != FILTOK) {
        errno = _dos_errno = ENOENT;
		return WEOF;
    }
    if (stream->orient == __or_narrow) {
        errno = EINVAL;
        return WEOF;
    }
    stream->orient = __or_wide;
    stream->flags &= ~_F_VBUF;
	if (!(stream->flags & _F_WRIT)) {
		stream->flags |= _F_ERR;
		errno = EFAULT;
		return WEOF;
	}
	if ((stream->flags & _F_IN) || 
			stream->buffer && ( stream->flags & _F_OUT) 
				&& stream->level >= 0) {
		if (fflush(stream))
			return WEOF;
		goto join;
	}
	else {
		if (!(stream->flags & _F_OUT)) {
join:
			stream->flags &= ~_F_IN;
			stream->flags |= _F_OUT;
			stream->level = -stream->bsize;
			stream->curp = stream->buffer;
		}
	}
	return __fputwc(c,stream);
}
wint_t _RTL_FUNC _fputwc(wchar_t c, FILE *stream)
{
	stream->level--;
	return fputc(c,stream);
}
wint_t _RTL_FUNC (putwc)(wchar_t c, FILE *stream)
{
	return fputc(c,stream);
}
wint_t _RTL_FUNC (putwchar)(wchar_t c)
{
	return fputc(c,stdout);
}