/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <string.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dir.h>
#include <wchar.h>
#include <locale.h>
#include <errno.h>
#include "libp.h"

extern int __uimodes[HANDLE_MAX],__uiflags[HANDLE_MAX], __uihandles[HANDLE_MAX] ;
extern char __uinames[HANDLE_MAX][256], __uidrives[HANDLE_MAX] ;

int _RTL_FUNC sopen  (const char *__path, int __access, int __shmode, ... /*unsigned mode*/)
{
   va_list ap ;
   int __amode,handle ;
   int i,h; 
   __ll_enter_critical() ;
   h = __uinewhandpos() ;
   if (h == -1) {
      __ll_exit_critical() ;
      return h ;
   }
   __uiflags[h] = 0 ;
   if (__path[1] == ':')
      __uidrives[h] = toupper(__path[0]) - 'A' ;
   else
      __uidrives[h] = getdisk() ;
   memcpy(&__uinames[h][0],__path,strlen(__path)) ;
   if (!(__access & (O_BINARY | O_TEXT)))
      __access |= _fmode ;
   if (__ll_writeable(__path))
      __uiflags[h] |= UIF_WRITEABLE ;
   if (__access & O_CREAT) {
      handle = __ll_open(__path,__ll_uioflags(__access),__ll_shflags(__shmode) ) ;
      if (__access & O_EXCL) {
         if (handle) {
			errno = EEXIST;
            __ll_close(handle) ;
            __ll_exit_critical() ;
            return -1 ;
         }
      }
      if (handle) {
         __uimodes[h] = __access ;
         __uihandles[h] = handle ;
         if (__access & O_TRUNC)
            chsize(h,0) ;
		 if (!__ll_isatty(handle))
	         __uiflags[h] |= UIF_EOF ;
      } else {
         handle = __ll_creat(__path,__ll_uioflags(__access),__ll_shflags(__shmode) ) ;
         if (handle == 0) {
            __ll_exit_critical() ;
            return -1 ;
         }
         __uimodes[h] = __access ;
         __uihandles[h] = handle ;
         if (__access & O_TRUNC)
            chsize(h,0) ;
         va_start(ap, __shmode) ;
         __amode = *(int *)ap ;
         if (!(__amode & S_IWRITE))
            __uiflags[h] |= UIF_RO ;
		if (!__ll_isatty(handle))
	         __uiflags[h] |= UIF_EOF ;
         va_end(ap) ;
      }
   } else {
      handle = __ll_open(__path,__ll_uioflags(__access),__ll_shflags(__shmode)) ;
      if (handle == 0) {
		  errno = ENOENT;
         __ll_exit_critical() ;
         return -1 ;
      }
      __uimodes[h] = __access ;
      __uihandles[h] = handle ;
      if (__access & O_TRUNC)
         chsize(h,0) ;
   }
   if (__uimodes[h] & O_APPEND) {
      if (lseek(h,0,SEEK_END) < 0) {
         close(h) ;
         __uihandles[h] = -1 ;
         __ll_exit_critical() ;
         return -1 ;
      }
	  if (!__ll_isatty(handle))
	      __uiflags[h] |= UIF_EOF ;
   }
   __ll_exit_critical() ;
   return h ;
}
int _RTL_FUNC _sopen  (const char *__path, int __access, int __shmode, ... /*unsigned mode*/)
{
   int mode ;
   va_list ap ;
   va_start(ap, __shmode) ;
   mode = *(int *)ap ;
   va_end(ap) ;
   return sopen(__path,__access, __shmode, mode) ;
}
