/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

extern int __uihandles[HANDLE_MAX], __uimodes[HANDLE_MAX], __uiflags[HANDLE_MAX] ;
extern char __uinames[HANDLE_MAX][256] ;

int _RTL_FUNC dup2(int __handle, int __newhandle)
{
   int h = __newhandle ;
   int i,ohand = __handle;
   if (h < 0 || h >= HANDLE_MAX) {
      errno = EBADF ;
      return -1 ;
   }
   __ll_enter_critical() ;
   __handle = __uiohandle(__handle) ;
   if (__handle == -1) {
      __ll_exit_critical() ;
      return -1 ;
   }
   i = __ll_dup(__handle) ;
   if (i == -1) {
      __ll_exit_critical() ;
      return -1 ;
   }
   if (__uihandles[h] != -1)
      close(h) ;
   __uimodes[h] = __uimodes[ohand] ;
   __uihandles[h] = i ;
   __uiflags[h] = __uiflags[ohand] ;
   strcpy(__uinames[h],__uinames[ohand]) ;
   __ll_exit_critical() ;
   return 0 ;
}
int _RTL_FUNC _dup2(int __handle, int __newhandle)
{
	return dup2(__handle, __newhandle);
}
