/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

int _fmode = O_TEXT;
int __uihandles[HANDLE_MAX], __uimodes[HANDLE_MAX],__uiflags[HANDLE_MAX] ;
char __uinames[HANDLE_MAX][256], __uidrives[HANDLE_MAX] ;

#pragma startup uio_init 138
#pragma rundown __uio_rundown 49 /* 11 */

static void uio_init(void)
{
   int i ;
   __ll_uioinit() ; /* sets first three handles */
   for (i=0; i < 3; i++) {
      __uimodes[i] = _fmode ;
   }
   for (i=3; i < HANDLE_MAX; i++)
      __uihandles[i] = -1 ;
}
void __uio_rundown(void)
{
   int i ;
   for (i=3; i < HANDLE_MAX; i++)
      if (__uihandles[i] != -1) {
         __ll_close(__uihandles[i]) ;
         __uihandles[i] = -1 ;
      }
}
int __uiohandle(int __handle)
{
   if (__handle >= HANDLE_MAX || __handle < 0) {
      errno = EBADF ;
      return -1 ;
   }
   if (__uihandles[__handle] == -1)
      errno = EBADF ;
   return __uihandles[__handle] ;
}
int __uinewhandpos(void)
{
   int i;
   for (i=0; i < HANDLE_MAX; i++)
      if (__uihandles[i] == -1)
         return i ;
   errno = EMFILE ;
   return -1 ;
}