#include <time.h>
#include <utime.h>
#include <io.h>
#include <fcntl.h>

int _RTL_FUNC _futime(int __handle, const struct utimbuf *times)
{
  int rv;
  struct tm *p, stm, sta;

  p = localtime (&times->modtime);
  if (!p)
	  return -1;
  stm = *p;
  p = localtime (&times->actime);
  if (!p)
	  return -1;
  sta = *p;

   __ll_enter_critical() ;
   __handle = __uiohandle(__handle) ;
   if (__handle == -1)   {
      __ll_exit_critical() ;
      return -1 ;
   }
   rv = __ll_utime(__handle, &sta, &stm);
   __ll_exit_critical() ;
   return rv ;

}
int _RTL_FUNC _utime(const char *path, const struct _utimbuf *times)
{
  int handle;
  int rv;
  
  if ((handle = open (path, O_RDWR)) == -1)
    return -1;

  rv = _futime(handle, times);

  close (handle);
  return rv;
}
int _RTL_FUNC utime (const char * path, const struct utimbuf * times)
{
	return _utime(path, times);
}
