/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <io.h>
#include <dos.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

extern int __uiflags[HANDLE_MAX],__uimodes[HANDLE_MAX] ;

int _RTL_FUNC read(int __handle, void *__buf, unsigned __len)
{
   char *pos=__buf ;
   char *dest = __buf ;
   int readlen ;
   int ohand = __handle ;
   __ll_enter_critical() ;
   __handle = __uiohandle(__handle) ;
   if (__handle == -1) {
      __ll_exit_critical() ;
      return -1 ;
   }
   if (__uimodes[ohand] & O_WRONLY) {
      __ll_exit_critical() ;
      errno = EBADF ;
      return -1 ;
   }
   if (__uiflags [ohand] & UIF_EOF)
   {
	  __ll_exit_critical();
      return 0 ;
   }
   if (__uimodes[ohand] & O_BINARY) {
      int i ;
      for (i=0 ; i < 3; i++) {
         readlen = __ll_read(__handle,dest,__len) ;
         if (readlen >= 0)
            break ;
         sleep(1) ;
      }
      if (readlen == -1) {
         __ll_exit_critical() ;
         return -1 ;
      }
      if (readlen < __len && !__ll_isatty(__handle)) 
         __uiflags[ohand] |= UIF_EOF ;
      __ll_exit_critical() ;
      return readlen ;
         
   } else {
      int i ;
      for (i=0 ; i < 3; i++) {
         readlen = __ll_read(__handle,dest,__len) ;
         if (readlen >= 0)
            break ;
         sleep(1) ;
      }
      if (readlen == -1) {
         __ll_exit_critical() ;
         return -1 ;
      }
      if (readlen < __len && !__ll_isatty(__handle))
         __uiflags[ohand] |= UIF_EOF ;
      for (i=0; i < readlen; i++) {
         switch (*pos) {
            case '\x1a':
				if (!__ll_isatty(__handle))
	               __uiflags[ohand] |= UIF_EOF ;
               __ll_exit_critical() ;
               return dest - __buf ;
            case '\r':
               pos++ ;
               break ;
            default:
               *dest++ = *pos++ ;
               break ;
         }
      }
      __ll_exit_critical() ;
      return dest - __buf ;
   }
}
int _RTL_FUNC _read(int __handle, void *__buf, unsigned __len)
{
	return read(__handle, __buf, __len);
}
