/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdlib.h>

char * _RTL_FUNC _ui64toa(unsigned __int64 __value, char *__string, int __radix)
{
   char buf2[36] ;
   int len = 0, pos = 0 ;
   if (__radix < 2 || __radix > 36)
      __string[pos] = 0 ;
   else if (!__value) {
         __string[pos++] = '0' ;
         __string[pos] = 0 ;
   } else {
      while (__value) {
         buf2[len++] = __value % __radix ;
         __value /= __radix ;
      }
      while (len) {
         int ch = buf2[--len] ;
         ch+= '0' ;
         if (ch > '9')
            ch += 7 ;
         __string[pos++] = ch ;
      }
      __string[pos] = 0 ;
   }
   return __string ;
}
