/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <String.h>
#include <ctype.h>
#include <limits.h>
#include <time.h>
#include <errno.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

#define nextchar { *ch = fgetc(fil); \
					(*chars)++; \
                    if (!count) return val; \
                    else count--; };

LLONG_TYPE __xstrtoimax(FILE *fil, int count, int *ch, int *chars,
        int radix, unsigned LLONG_TYPE max, int full, int errmode)
{
   int sign = 0;
   unsigned LLONG_TYPE val = 0;
   unsigned LLONG_TYPE imax ;
   int lim ;
    int temp;
	int err = 0;    
    count--;
    if (radix > 36 || radix < 0)
        return 0;
                 
    while (isspace(*ch)) nextchar;

	if (*ch == '-') {
		sign++;
		nextchar;
	}
	else if (*ch == '+') 
		nextchar;
    if (*ch == '0') {
      if (!radix) {
        radix = 8;
        nextchar;
        if (*ch == 'x' || *ch == 'X') {
           radix = 16;
           nextchar;
           if (!isxdigit(*ch)) {
             return 0;   
           }
        }
      } else if (radix == 16) {
         nextchar; 
         if (*(ch) == 'x' || *(ch) == 'X') {
            nextchar;
            if (!isxdigit(*ch))
                return 0;
         }
      }
    }
	if (!isalnum(*ch))
		return 0;
    if (!radix)
      radix = 10 ;
    lim = (ULLONG_MAX % radix) ;
    imax = ULLONG_MAX / radix ;
	while(isalnum(*ch)) {
        unsigned temp = toupper(*ch)- '0';
		if (temp >= 10)
			temp -= 7;
        if (temp >= radix)
                break ;
        else if (val > imax || val == imax && temp > lim) {
				err = 1;
		}
		val*= radix;
		val += temp;
        nextchar;
        if (*ch == EOF)
			break;
	}
	switch (errmode)
	{
		case STRT_ERR_RET_CV:
			if (sign)
				val = - val;
			break;
		case STRT_ERR_RET_SIGNED:
			if (err || val > max/2 && (!sign || val != max/2))
			{
				errno = ERANGE;
				if (sign)
					val = -(max/2+1);
				else
					val = max/2;
			}
			else if (sign)
				val = - val;
			break;
		case STRT_ERR_RET_UNSIGNED:
			if (err || val > max)
			{
				errno = ERANGE;
				val = max;
			}
			else if (sign)
				val = - val;
			break;
	}
	return val;
}
static LLONG_TYPE __xstrtol(const char *buf, int width, char **endptr,
        int radix, unsigned LLONG_TYPE max, int full, int errmode)
{
   LLONG_TYPE rv ;
   int ch ;
   FILE fil ;
   int chars = 0;
   memset(&fil,0,sizeof(fil)) ;
   fil.level = strlen(buf)+2 ;
   fil.flags = _F_IN | _F_READ | _F_BUFFEREDSTRING ;
   fil.bsize = strlen(buf) ;
   fil.buffer = fil.curp = buf ;
   fil.token = FILTOK ;
   ch = fgetc(&fil) ;
   rv = __xstrtoimax(&fil,width,&ch,& chars,radix,max,full, errmode) ;
   if (endptr) {
      *endptr = fil.curp;
      if (fil.curp != fil.buffer)
        (*endptr)--;
   }
   return rv ;
}
LLONG_TYPE _RTL_FUNC strtoimax(const char * restrict nptr, 
                              char ** restrict endptr, int base)
{
    return __xstrtol(nptr,INT_MAX,endptr,base, ULLONG_MAX,1, STRT_ERR_RET_SIGNED);  
} 
unsigned LLONG_TYPE _RTL_FUNC strtoumax(const char * restrict nptr, 
                               char ** restrict endptr, int base)
{
    return __xstrtol(nptr,INT_MAX,endptr,base, ULLONG_MAX,1, STRT_ERR_RET_UNSIGNED);
}
LLONG_TYPE _RTL_FUNC strtoll(const char * restrict nptr, 
                              char ** restrict endptr, int base)
{
    return __xstrtol(nptr,INT_MAX,endptr,base, ULLONG_MAX,1, STRT_ERR_RET_SIGNED); 
} 
unsigned LLONG_TYPE _RTL_FUNC strtoull(const char * restrict nptr, 
                               char ** restrict endptr, int base)
{
    return __xstrtol(nptr,INT_MAX,endptr,base, ULLONG_MAX,1, STRT_ERR_RET_UNSIGNED);                             
}
long  _RTL_FUNC strtol(const char * restrict s, char ** restrict endptr , int radix)
{
   return (long) __xstrtol(s,INT_MAX,endptr,radix,ULONG_MAX,1, STRT_ERR_RET_SIGNED) ;
}
unsigned long  _RTL_FUNC strtoul(const char * restrict s, char ** restrict endptr , int radix)
{
   return (unsigned long)__xstrtol(s,INT_MAX,endptr,radix,ULONG_MAX,1, STRT_ERR_RET_UNSIGNED) ;
}
LLONG_TYPE  _RTL_FUNC atoll(const char *s)
{
   return (LLONG_TYPE)__xstrtol(s,INT_MAX,0,10,ULLONG_MAX,1, STRT_ERR_RET_CV);
}
__int64  _RTL_FUNC _atoi64(const char *s)
{
   return (__int64)__xstrtol(s,INT_MAX,0,10,_UI64_MAX,1, STRT_ERR_RET_CV);
}
long  _RTL_FUNC atol(const char *s)
{
   return (long)__xstrtol(s,INT_MAX,0,10,ULONG_MAX,1, STRT_ERR_RET_CV);
}
int  _RTL_FUNC atoi(const char *s)
{
   return (int)__xstrtol(s,INT_MAX,0,10,UINT_MAX,1, STRT_ERR_RET_CV);
}
