/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdlib.h>

void *_RTL_FUNC bsearch(const void *key, const void *base, size_t num, size_t width,
			int (*compare)(const void *elem1, const void *elem2))
{
	int bottom = -1;
	int top = num;
	int l;
    
    if (!num)
        return 0;

	while (top - bottom > 1) {
		int mid = (top + bottom)/2;
		l=(*compare)(key,(char *)base + mid*width) ;

		if (l > 0)
			bottom = mid;
		else
			top = mid;
	}
	if (top == num)
		return 0 ;
	l=(*compare)(key,(char *)base + top*width) ;
	if (l)
		return 0 ;

	return (char *)base + top * width;
}
