/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stddef.h>
#include <locale.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <wchar.h>
#include "libp.h"
#include "_locale.h"

static char *stringbufptr;

extern void * __locale_data[LC_LAST+1];
static char *tostring(char *str, char **stringbufptr)
{
    char *rv = *stringbufptr;
    while (*str)
        *(*stringbufptr)++ = *str++;
    *(*stringbufptr)++ = *str++;
    return rv;
}
struct lconv *  _RTL_FUNC localeconv( void )
{
    MONETARY_DATA *monetary_data =((MONETARY_DATA *)(__locale_data[LC_MONETARY])) ;
    NUMERIC_DATA *numeric_data = ((NUMERIC_DATA *)(__locale_data[LC_NUMERIC])) ;
    struct lconv *lc = &__getRtlData()->lconvbuf;
    char *stringbuf = __getRtlData()->lconvstringbuf;
    char *stringbufptr = stringbuf;

    lc->decimal_point = tostring(numeric_data->decimal_point,&stringbufptr);
    lc->thousands_sep = tostring(numeric_data->thousands_sep,&stringbufptr);
    lc->grouping = tostring(numeric_data->grouping,&stringbufptr);

    lc->int_curr_symbol = tostring(monetary_data->int_curr_symbol,&stringbufptr);
    lc->currency_symbol = tostring(monetary_data->currency_symbol,&stringbufptr);
    lc->mon_decimal_point = tostring(monetary_data->mon_decimal_point,&stringbufptr);
    lc->mon_thousands_sep = tostring(monetary_data->mon_thousands_sep,&stringbufptr);
    lc->mon_grouping = tostring(monetary_data->mon_grouping,&stringbufptr);
    lc->positive_sign = tostring(monetary_data->positive_sign,&stringbufptr);
    lc->negative_sign = tostring(monetary_data->negative_sign,&stringbufptr);
    lc->int_frac_digits = monetary_data->int_frac_digits;
    lc->frac_digits = monetary_data->frac_digits;
    lc->p_cs_precedes = monetary_data->p_cs_precedes;
    lc->p_sep_by_space = monetary_data->p_sep_by_space;
    lc->n_cs_precedes = monetary_data->n_cs_precedes;
    lc->n_sep_by_space = monetary_data->n_sep_by_space;
    lc->p_sign_posn = monetary_data->p_sign_posn;
    lc->n_sign_posn = monetary_data->n_sign_posn;
    lc->int_p_cs_precedes = monetary_data->int_p_cs_precedes;
    lc->int_p_sep_by_space = monetary_data->int_p_sep_by_space;
    lc->int_n_cs_precedes = monetary_data->int_n_cs_precedes;
    lc->int_n_sep_by_space = monetary_data->int_n_sep_by_space;
    lc->int_p_sign_posn = monetary_data->int_p_sign_posn;
    lc->int_n_sign_posn = monetary_data->int_n_sign_posn;    
    return &lc;
}
struct lconv *  _RTL_FUNC _llocaleconv( void )
{
    return localeconv();
}
