/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stddef.h>
#include <ctype.h>
#include <locale.h>
#include "_locale.h"

#define ct_data (*(CTYPE_DATA *)(__locale_data[LC_CTYPE]))

int _RTL_FUNC (tolower)(int c)
{
   if ((unsigned)c >= 256)
      return c ;
    if (ct_data.flags & 1)
        c = ct_data.tolower[c];
    else
    	if (_ctype[c] & _IS_UPP)
	    	c+=32;
	return c;
}
int _RTL_FUNC (toupper)(int c)
{
   if ((unsigned)c >= 256)
      return c ;
    if (ct_data.flags & 1)
        c = ct_data.toupper[c];
    else
    	if (_ctype[c] & _IS_LOW)
	    	c-=32;
	return c;
}
int _RTL_FUNC (_tolower)(int c)
{
    return tolower(c);
}
int _RTL_FUNC (_toupper)(int c)
{
    return toupper(c);
}
int _RTL_FUNC (_ltolower)(int c)
{
    return tolower(c);
}
int _RTL_FUNC (_ltoupper)(int c)
{
    return toupper(c);
}
int _RTL_FUNC (isspace)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_SP) ;
}
int _RTL_FUNC (isalpha)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & (_IS_UPP | _IS_LOW)) ;
}
int _RTL_FUNC (ispunct)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_PUN) ;
}
int _RTL_FUNC (islower)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_LOW) ;
}
int _RTL_FUNC (isupper)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_UPP) ;
}
int _RTL_FUNC (isprint)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & (_IS_PRINT)) ;
}

int _RTL_FUNC (isalnum)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & (_IS_UPP | _IS_LOW | _IS_DIG)) ;
}
int _RTL_FUNC (isgraph)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_GRAPH) ;
}
int _RTL_FUNC (isdigit)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_DIG) ;
}
int _RTL_FUNC (isxdigit)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
   return (_ctype[c] & _IS_HEX) ;
}
int _RTL_FUNC (toascii)(int c)
{
   return (c & 0x7f) ;
}
int _RTL_FUNC (__toascii)(int c)
{
   return (c & 0x7f) ;
}
int _RTL_FUNC (isascii)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
	return ( c < 0x80);
}
int _RTL_FUNC (__isascii)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
	return ( c < 0x80);
}
int _RTL_FUNC (iscntrl)(int c)
{
   if ((unsigned)c >= 256)
      return 0 ;
  return (_ctype[c] & _IS_CTL) ;
}
int _RTL_FUNC (_isctype)(int c, int flag)
{
   if ((unsigned)c >= 256)
      return 0 ;
	return(_ctype[c] & flag);
}
int _RTL_FUNC (__iscsymf)(int c)
{
	return isalpha(c) || c == '_';
}
int _RTL_FUNC (__iscsym)(int c)
{
	return isalnum(c) || c == '_';
}
