/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <new.h>
#include <stdlib.h>

namespace __dls {
   const char _RTL_DATA *__dls_bad_alloc = "bad_alloc" ;
} ;

namespace std {

   nothrow_t _RTL_DATA nothrow;
   _RTL_FUNC bad_alloc::~bad_alloc() 
   {
   }

} ;
       
static new_handler _new_handler ;

new_handler _RTL_FUNC set_new_handler(new_handler __newv)
{
   new_handler rv = _new_handler ;
   _new_handler = __newv ;
   return rv ;
}

void *__realnew(size_t n)
{
   if (!n)
      n = 1 ;
   do {
      void *rv = malloc(n) ;
      if (rv)
         return rv ;
      if (!_new_handler)
         throw std::bad_alloc() ;
      (*_new_handler)() ;
   } while (1) ;
   return 0 ; // never gets here
}