 ; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _csqrt]
[export _csqrtf]
[export _csqrtl]
%endif
[global _csqrt]
[global _csqrtf]
[global _csqrtl]
[extern _cabsl]

SECTION _DATA CLASS=DATA USE32
nm	db	"csqrt",0

two dd  2
four dd 4
twoe66 dw 0,0,0,800h,3fffh+66
twoem33 dw 0,0,0,800h,3fffh-33

SECTION _TEXT CLASS=CODE USE32

_csqrtf:
	lea	ecx,[esp+4]
    fld dword[ecx+4]
	fld	dword[ecx]
    jmp short csqrt
_csqrtl:
	lea	ecx,[esp+4]
    fld tword[ecx+10]
	fld	tword[ecx]
    jmp short csqrt
_csqrt:
	lea	ecx,[esp+4]
    fld qword[ecx+8]
	fld	qword[ecx]
csqrt:
    lea eax,[nm]
    call clearmath
    ftst
    fstsw ax
    sahf
    jnz xnot0
    popone
    ftst
    fnstsw ax
    fabs
    fidiv dword [two]
    fsqrt
    fld st0
    sahf
    jnc wrapcomplex
    fchs
    fxch
    jmp wrapcomplex
xnot0:
    fxch
    ftst
    fstsw ax
    sahf
    jnz ynot0
    popone
    ftst
    fstsw ax
    sahf
    jnc y0real
    fchs
    fsqrt
    fldz
    jmp wrapcomplex
y0real:
    fsqrt
    fldz
    fxch
    jmp wrapcomplex
ynot0:    
    push edx
    push ebp
    mov ebp,esp
    sub esp,12
    fld st0
    fabs
    ficomp dword [four]
    ja downsize
    fld st1
    fabs
    ficomp dword [four]
    jbe upsize
downsize:
    fidiv dword [four]
    fxch
    fidiv dword [four]
    fild dword [two]
    fstp tword [esp]
    jmp sizejoin
upsize:
    fld tword [twoe66]
    fmulp st1
    fxch
    fld tword [twoe66]
    fmulp st1
    fld dword [twoem33]
    fstp tword [esp]
sizejoin:
    sub esp,20
    fstp tword [esp]
    fstp tword [esp + 10]
    call _cabsl
    fidiv dword [two]
    fld tword [esp]
    ftst
    fnstsw ax
    fidiv dword [two]
    fabs
    faddp st1
    fsqrt
    fld tword [esp + 10]
    fidiv dword [two]
    fdiv st1
    fabs
    fld tword [ebp-12]
    fmulp st1
    fxch
    fld tword [ebp-12]
    fmulp st1
    sahf
    jbe xlessjn
    fxch
xlessjn:
    fld tword [esp+10]
    ftst
    fnstsw ax
    popone
    sahf
    jae ygreatjn
    fchs
ygreatjn:
    fxch
    leave
    pop edx
    jmp wrapcomplex
