 ; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"
%ifdef __BUILDING_LSCRTL_DLL
[export _catan]
[export _catanf]
[export _catanl]
%endif
[global _catan]
[global _catanf]
[global _catanl]
[extern _logl]
[extern _atan2l]
[extern redupil]

SECTION _DATA CLASS=DATA USE32
nm	db	"catan",0

two dd 2
four dd 4
SECTION _TEXT CLASS=CODE USE32

_catanf:
	lea	ecx,[esp+4]
    fld dword[ecx+4]
	fld	dword[ecx]
    sub dl,dl
    jmp short catan
_catanl:
	lea	ecx,[esp+4]
    fld tword[ecx+10]
	fld	tword[ecx]
    mov dl,2
    jmp short catan
_catan:
	lea	ecx,[esp+4]
    fld qword[ecx+8]
	fld	qword[ecx]
    mov dl,1
catan:
    lea eax,[nm]
    call clearmath
    push edx
    sub esp,20
    fldz
    fcomp st1
    fnstsw ax
    sahf
    jnz  ok1
    fld1
    fcomp st2
    fnstsw ax
    sahf
    jae ok1
ovrf:
    add esp,20
    pop edx
    poptwo
    fld tword [large_t]
    fld st0
    call overflow
    jmp wrapcomplex
ovrf2:
    popone
    jmp ovrf
ok1:
    fld st0
    fmul st0
    fld st0
    fstp tword [esp+10] ; x^2
    fld st2
    fmul st0
    faddp st1
    fchs
    fld1
    faddp st1
    ftst
    fnstsw ax
    sahf
    jz ovrf2
    sub esp,24
    fstp tword [esp+12]
    fimul dword [two]
    fstp tword [esp]
    call _atan2l
    add esp,24
    fidiv dword [two]
    call redupil
    fld st1
    fld1
    fsubp st1
    fld st0
    fmulp st1
    fld tword [esp+10]
    faddp st1
    
    fxch st2
    fld1
    faddp st1
    fld st0
    fmulp st1
    fld tword [esp+10]
    faddp st1
    fdivp st2
    fxch
    fstp tword [esp]
    call _logl
    fidiv dword[four]
    fxch
    add esp,20
    pop edx
    jmp wrapcomplex    
