/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <time.h>
#include <stdio.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

char _monthdays[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };


struct tm *_RTL_FUNC gmtime(const time_t *time)
{
    struct tm *rv = &__getRtlData()->gmtime_buf;
	time_t t = *time;
	int temp1,x=0;
	
	if (t & 0x80000000)
		return NULL;
	rv->tm_sec = t %60;
	t/=60;
	rv->tm_min = t %60;
	t /=60;
	rv->tm_hour = t %24;
	t /=24;
	rv->tm_yday = t;
	rv->tm_wday = (t +4 )%7;
	rv->tm_year = 70+(rv->tm_yday /365);
	rv->tm_yday = rv->tm_yday % 365;
	rv->tm_yday -= (rv->tm_year - 69)/4 ;
	if (rv->tm_yday <0) {
        rv->tm_yday += 365;
		rv->tm_year--;
	}
	if (((rv->tm_year-68) %4 == 0)) {
		_monthdays[1] = 29;
	}
	else
		_monthdays[1] = 28;
	temp1 = rv->tm_yday;
	rv->tm_mon = -1;
	while (temp1 >=0) 
		temp1-=_monthdays[++rv->tm_mon];
	rv->tm_mday = temp1 + _monthdays[rv->tm_mon]+1;
	rv->tm_isdst = 0;
   return rv;
}
	