
#ifndef __SEARCH_H
#define __SEARCH_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#ifdef __cplusplus
namespace std {
extern "C" {
#endif
void *      _RTL_FUNC bsearch(const void * __key, const void * __base,
                           size_t __nelem, size_t __width,
                           int (*fcmp)(const void *, const void *));
void *      _RTL_FUNC lfind(const void * __key, const void * __base,
                                size_t * __num, size_t __width,
                                int (*fcmp)(const void *, const void *));
void *      _RTL_FUNC lsearch(const void * __key, void * __base,
                                size_t * __num, size_t __width,
                                int (*fcmp)(const void *, const void *));
void        _RTL_FUNC qsort(void * __base, size_t __nelem, size_t __width,
                         int (*__fcmp)(const void *, const void *));

void * _RTL_FUNC _lfind(const void *, const void *, unsigned int *, unsigned int,
        int (*)(const void *, const void *));
void * _RTL_FUNC _lsearch(const void *, void  *, unsigned int *, unsigned int,
                                int (*)(const void *, const void *));
						  
#ifdef __cplusplus
}
}
#endif

#endif  /* __SEARCH_H */

#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__SEARCH_H_USING_LIST)
#define __SEARCH_H_USING_LIST
using std::bsearch;
using std::lfind;
using std::lsearch;
using std::_lfind;
using std::_lsearch;
using std::qsort;
#endif /* __USING_CNAME__ */
