/*  stddef.h  

    Definitions for common types, and NULL

*/

#ifndef __STDDEF_H
#define __STDDEF_H

#ifndef __DEFS_H__
#include <_defs.h>
#endif

#ifdef __cplusplus
namespace std {
#endif

#ifndef _PTRDIFF_T
#define _PTRDIFF_T
typedef int    ptrdiff_t;
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#ifndef _WCHAR_T_DEFINED
#define _WCHAR_T_DEFINED
#ifndef __cplusplus
typedef unsigned short wchar_t;
#endif
#endif

#ifndef FAR
#define FAR _FAR
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef offsetof
#define offsetof( s_name, m_name )  (size_t)&(((s_name *)0)->m_name)
#endif

#ifndef _WCTYPE_T_DEFINED
typedef unsigned int wctype_t;
#define _WCTYPE_T_DEFINED
#endif

#ifndef _WINT_T_DEFINED
#define _WINT_T_DEFINED
typedef unsigned int wint_t;
#endif

#ifdef __cplusplus
} ;
#endif
#endif  /* __STDDEF_H */
#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__STDDEF_H_USING_LIST)
#define __STDDEF_H_USING_LIST
using std::ptrdiff_t ;
using std::size_t ;
using std::wint_t;
using std::wctype_t ;
#endif
