/*  malloc.h

    memory management functions and variables.

*/

#ifndef __MALLOC_H
#define __MALLOC_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#define _HEAPEMPTY      1
#define _HEAPOK         2
#define _FREEENTRY      3
#define _USEDENTRY      4
#define _HEAPEND        5
#define _HEAPCORRUPT    -1
#define _BADNODE        -2
#define _BADVALUE       -3

#ifdef __cplusplus
namespace std {
extern "C" {
#endif

#ifdef __CC386__
#define _fmalloc(size) farmalloc(size)
#define _ffree(size)  farfree(size)
#endif

void        _RTL_FUNC *calloc(size_t __nitems, size_t __size);
void        _RTL_FUNC free(void *__block);
void        _RTL_FUNC *malloc(size_t __size);
void        _RTL_FUNC *realloc(void *__block, size_t __size);
#ifdef __CC386__
void        _RTL_FUNC _FAR *farmalloc(size_t __size) ;
void        _RTL_FUNC farfree(void _FAR *__block) ;
#endif

#ifdef __cplusplus
} ;
} ;
#endif

#endif  /* __MALLOC_H */
#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__MALLOC_H_USING_LIST)
#define __MALLOC_H_USING_LIST
	using std::calloc ;
	using std::free ;
	using std::malloc ;
	using std::realloc ;
#ifdef __CC386__
	using std::farmalloc ;
	using std::farfree ;
#endif

#endif
