
/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include <signal.h>
#include "libp.h"
extern void __ll_sigsegv(int) ;

int _abterm=0;

void _RTL_FUNC _abort()
{
   fprintf(stderr,"\nAbnormal program termination") ;
   fflush(stderr);
   _abterm = 1;
   _exit(3);

}

static void sigterm(int aa)
{
   _exit(1);
}
static void sigint(int aa)
{
   _exit(1) ;
}
static void sigill(int aa)
{
   fprintf(stderr,"\nIllegal instruction") ;
   fflush(stderr);
   _exit(1) ;
}
static void sigfp(int aa)
{
//    unsigned short bb;
//    asm fnstsw word [bb];
   fprintf(stderr,"\nfloating point or divide by zero exception") ;
//   fprintf(stderr," %04x\n",bb);
   fflush(stderr);
   _exit(1) ;
}
static void sigabort(int aa)
{
   _abort() ;
}
const sighandler_t __defsigtab[NSIG] = {
    SIG_ERR, SIG_ERR,  sigint,  SIG_ERR,   
    sigill, SIG_ERR,  SIG_ERR, SIG_ERR, 
    sigfp, SIG_ERR,  SIG_ERR, __ll_sigsegv, 
    SIG_ERR, SIG_ERR, SIG_ERR, sigterm, 
    SIG_IGN, SIG_IGN,SIG_ERR, SIG_ERR, 
    SIG_IGN, sigint, sigabort
};

sighandler_t __sigtab[NSIG];
static char insignal[NSIG];

#pragma startup siginit 149

static void siginit(void)
{
	int i;
	for (i=0; i < NSIG; i++)
		__sigtab[i] = __defsigtab[i];
}
int _RTL_FUNC raise(int sig)
{
	sighandler_t temp;
   if (sig >= NSIG || sig < 1) {
		errno = EINVAL;
      return 1;
	}
    temp = __sigtab[sig];
	if (temp == SIG_ERR)
		return 1;
	if (temp == SIG_IGN)
      return 0;
	while (insignal[sig])
		sleep(1);
	__sigtab[sig] = __defsigtab[sig];
	insignal[sig]++;
	(*temp)(sig);
	insignal[sig]--;
	__ll_cancelsleep();
	return 0;
}