/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <dpmi.h>
#include <dos.h>
#include <dir.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

int _RTL_FUNC         mkdir( const char  *__path )
{
	DPMI_REGS regs;
	SELECTOR sel,para;
	if (dpmi_alloc_real_memory(&sel,&para,0x8))
		return 8;
	dpmi_copy_from_ds(sel,0,__path,strlen(__path)+1);
	regs.b.ah = 0x39;
	regs.h.flags = 0x72;
	regs.h.ss = 0;
	regs.h.sp = 0;
	regs.h.ds = para;
	regs.h.dx = 0;
	dpmi_simulate_real_interrupt(0x21,&regs);
	dpmi_dealloc_real_memory(sel);
	if (regs.h.flags & 1) {
		_dos_errno = regs.b.al;
		errno = ENOENT;
		return -1;
	}
	return 0;
}
int _RTL_FUNC         _mkdir( const char  *__path )
{
	return mkdir(__path);
}
