/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <time.h>
#include <stdio.h>
#include <wchar.h>
#include <locale.h>
#include <errno.h>
#include "libp.h"
#include <dpmi.h>
#include "llp.h"

extern int __dtabuflen ;
int __ll_read(int fd, void *buf, size_t size)
{
	DPMI_REGS regs;
	int mod = size %__dtabuflen,i, tsize = 0;
	for (i=0; i < (size & -__dtabuflen); i += __dtabuflen) {
		regs.h.dx = 0;
		regs.h.bx = fd;
		regs.h.cx = __dtabuflen;
		__doscall(0x3f,&regs);
		if (regs.h.flags & 1)
			return -1;
		__dtatobuf((char *)buf+i,__dtabuflen);
		tsize += regs.h.ax;
		if (regs.h.ax < __dtabuflen)
			return tsize;
	}
	regs.h.dx = 0;
	regs.h.bx = fd;
	regs.h.cx = mod;
	__doscall(0x3f,&regs);
	tsize += regs.h.ax;
	if (regs.h.flags & 1)
		return -1;
	__dtatobuf((char *)buf+i,mod);
	return tsize;
}
