/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <dpmi.h>
#include <errno.h>
 #include "llp.h"

#define FROMBCD(x) (((x)>>4)*10 +((x)& 0xf))
#define TOBCD(x) ((((x)/10)<<4) + ((x) % 10))
struct tm *__ll_gettime(struct tm *tm2)
{
	DPMI_REGS regs;
	memset(tm2,0,sizeof(struct tm));
	regs.b.ah = 2;
	__realint(0x1a,&regs);

  tm2->tm_sec = FROMBCD(regs.b.dh);
  tm2->tm_min = FROMBCD(regs.b.cl);
  tm2->tm_hour = FROMBCD(regs.b.ch);

	regs.b.ah = 4;
	__realint(0x1a,&regs);

  tm2->tm_mday = FROMBCD(regs.b.dl);
  tm2->tm_mon = FROMBCD(regs.b.dh)-1;
  tm2->tm_year = FROMBCD(regs.b.cl);
	if (tm2->tm_year < 71)
		tm2->tm_year += 100;
	return tm2;
}
