/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <dpmi.h>
#include <errno.h>
 #include "llp.h"

extern int __dtabuflen ;

UWORD _dtaseg;
SELECTOR _dtasel;

#pragma startup initdta 140
#pragma rundown freedta 10

static void initdta(void)
{
   DPMI_REGS r ;
   DESCRIPTOR desc ;
   int val ;
   dpmi_alloc_real_memory(&_dtasel,&_dtaseg,(__dtabuflen + 15)/16); /* 2048 bytes */
}
static void freedta(void)
{
   dpmi_dealloc_real_memory(_dtasel);
}

int __nametodta(char *name, int index)
{
	int len = strlen(name) + 1;
   dpmi_copy_from_ds(_dtasel,index,name,len);
	return index;
}
int __buftodta(unsigned char *buf, int len)
{
   dpmi_copy_from_ds(_dtasel,0,buf,len);
	return 0;
}
int __dtatobuf(unsigned char *buf, int len)
{
   dpmi_copy_to_ds(buf,_dtasel,0,len);
	return 0;
}
