/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <dos.h>
#include <dpmi.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"
#include <errno.h>

extern int __dtabuflen ;
unsigned _RTL_FUNC _dos_read(int __fd, void *__buf, unsigned __len, unsigned *__nread)
{
	DPMI_REGS regs;
   int mod = __len %__dtabuflen,i, tsize = 0;
   for (i=0; i < (__len & -__dtabuflen); i += __dtabuflen) {
		regs.h.dx = 0;
      regs.h.bx = __fd;
		regs.h.cx = __dtabuflen;
		__doscall(0x3f,&regs);
		if (regs.h.flags & 1)
         return errno = regs.b.al ;
      __dtatobuf((char *)__buf+i,__dtabuflen);
		tsize += regs.h.ax;
      if (regs.h.ax < __dtabuflen) {
         *__nread = tsize ;
         return 0 ;
      }
	}
	regs.h.dx = 0;
   regs.h.bx = __fd;
	regs.h.cx = mod;
	__doscall(0x3f,&regs);
	tsize += regs.h.ax;
	if (regs.h.flags & 1)
         return errno = regs.b.al ;
   __dtatobuf((char *)__buf+i,mod);
   *__nread = tsize ;
   return 0;
}
