/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <dos.h>
#include <dpmi.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"
#include <errno.h>

unsigned _RTL_FUNC _dos_getdiskfree(unsigned __drive,struct diskfree_t *__dtable)
{
   DPMI_REGS regs ;
   regs.h.ax = 0 ;
   regs.h.dx = __drive ;
   __doscall(0x36,&regs) ;
   if (regs.h.flags & 1) {
      errno = EINVAL ;
      return regs.b.al ;
   }
   __dtable->sectors_per_cluster = regs.h.ax ;
   __dtable->bytes_per_sector = regs.h.cx ;
   __dtable->total_clusters = regs.h.dx ;
   __dtable->avail_clusters = regs.h.bx ;
   return 0 ;
}
