; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
	.386p        
	.model use32 small

include  dispatch.ase 
include  prints.ase 
include  mtrap.ase 
include  regs.ase 
include  dump.ase 
include  entry.ase 
include  exec.ase 
include  breaks.ase 
include  dis.ase 
include  inout.ase
include asm.asi
include asm.ase

	PUBLIC	qerr, ReadNumber, ReadAddress, InputHandler
	PUBLIC	WadeSpace, PageTrapErr, PageTrapUnerr, GetInputLine
	PUBLIC	InputBuffer

	extrn _exit : PROC,domath : PROC, drive : PROC, fill : PROC
	extrn Help : PROC
	extrn search : PROC
	extrn fpcommand : PROC
	extrn move : PROC, compare : PROC

IBSIZE = 80

	.data
oldpagetrap	df	0		; Temp store for user page trap
InputBuffer db	IBSIZE DUP (?)		; Input buffer
Commands db	"abcdefghimopqrstu?/"	; List of Commands
comlen	= $ - Commands			; Length of list
inquote	db	0
lastcmd db 0
	.code
;
; Print an error if command wrong
;
qerr	PROC	
	call	crlf
	sub	esi,offset InputBuffer-2; Calculate error pos
	mov	ecx,esi			;
	jcxz	short qestart		;
	dec	ecx			;
	jcxz	short qestart		;
qelp:					
	call	PrintSpace              ; Space over to error pos
     	loop	qelp
qestart:
	mov	dl,'^'			; Display error
	call	PureChar
	stc				; Did an error
	ret	
qerr	ENDP	
;
; If paging traps, it comes here
;
PageTrapped	PROC	
	mov	esp,[rtoss]		;
	call	PageTrapUnerr		; Turn page trap off
	Msg	<db 10,13,"Invalid paging">	; Message for page trap
	jmp	InputHandler		; Go do more input
PageTrapped	ENDP	
;
; Set up monitor page trap error
;
PageTrapErr	PROC	
	pusha
	mov 	bl,14			; get user trap vect
	mov 	ax,204h
	int	31h
	
	mov	DWORD PTR [oldpagetrap],edx;
	mov	WORD PTR [oldpagetrap + 4],cx;
	mov	ecx,cs			; Set MONITOR trap interrupt
	mov	edx,offset PageTrapped	;
	mov	ax,205h
	int 	31h
	popa
	ret
PageTrapErr	ENDP	
;
; Set user page trap error ( unset monitor error)
;
PageTrapUnerr	PROC	
	pusha
	mov	edx,DWORD PTR [oldpagetrap]	; Restore user value
	mov	cx,WORD PTR [oldpagetrap + 4]	;
	mov	ax,205h
	int 	31h
	popa
	ret
PageTrapUnerr	ENDP	
;
; Read in a number
;
ReadNumber	PROC	
	push	ebx
	push	ecx
	push	edx
	call	ReadReg
	clc
	jz	gotnum
	sub	ebx,ebx			; Number = 0
	sub	ecx,ecx			; digits = 0
	mov	al,[esi]
	cmp	al,"'"
	jz	getstring
	cmp	al,'"'
	jz	getstring
rnlp:
	lodsb				; Get char & convert to uppercase
	cmp	al,60h
	jc	notlower
	and	al,NOT 20h
notlower:
	sub	al,'0'    		; Convert to binary
	jc	short rn_done		; < '0' is an error
	cmp	al,10			; See if is a digit
	jc	short gotdigit		; Yes, got it
	sub	al,7			; Convert letters to binary
	cmp	al,16			; Make sure is < 'G'
	jnc	short rn_done		; Quit if not
	cmp	al,10			; MAke sure not < 'A'
	jc	short rn_done
gotdigit:
	shl	ebx,4			; It is a hex digit, add in
	or	bl,al			;
	inc	ecx			; Set flag to indicate we got digits
	jmp	rnlp
rn_done:
	dec	esi			; Point at first non-digit
rm_done2:
	mov	eax,ebx
	test	cl,-1			; See if got any
	jnz	gotnum			;
	stc				; No, error
gotnum:
	pop	edx
	pop	ecx
	pop	ebx
	ret	
getstring:
	inc si
getstringl:
	lodsb
	cmp	al,13
	jz	rn_done
	cmp	al,"'"
	jz	rm_done2
	cmp	al,'"'
	jz	rm_done2
	inc	cl
	shl	ebx,8
	mov	bl,al
	jmp	getstringl
ReadNumber	ENDP	
;
; Read an address, composed of a number and a possible selector
;
ReadAddress	PROC	
	call	ReadNumber
	mov	ebx,eax
	ret
ReadAddress	ENDP	
;
; Get an input line
;
GetInputLine	PROC	
	mov	[inquote],0
	mov	edi,offset DGROUP:InputBuffer	; Get input buffer
	mov	esi,edi			; Return buffer pointer
	mov	ecx,IBSIZE		; Size of buffer
moreinput:
	call	GetKey
	cmp	al,8			; Is delete or rubout?
	jz	short bkspc		; Yes - go do it
	cmp	al,7fh			;
	jz	short bkspc		; yes - go do it
	cmp	al,'"'
	jz	doquote
	cmp	al,"'"
	jnz	dochar
doquote:
	xor	[inquote],1
dochar:
	push	eax
	test	[inquote],1
	jnz	nolc
	cmp	al,'A'
	jc	nolc
	cmp	al,'Z'
	ja	nolc
	or	al,20h
nolc:
	stosb
	pop	eax
	cmp	al,13			; Is CR
	jz	short endinput		; Yes, return
	mov	dl,al			; Echo character
	call	PutChar
	loop	moreinput		; Loop till buffer full
endinput:
	ret
bkspc:
	cmp	edi,offset DGROUP:InputBuffer	; Quit if nothing in buffer
	jz	moreinput		; And get more input
	mov	dl,8			; Erase last echoed char
	call	PutChar
	mov	dl,' '			;
	call	PutChar
	mov	dl,8			; Reset pointer
	call	PutChar
	dec	di			; Point at last char
	jmp	moreinput		; Get more input
GetInputLine	ENDP	
;
; Wade pasth spaces
;
WadeSpace	PROC	
	lodsb				; Get char
	cmp	al,' '			; if ' ' or ',' go again
	jz	short WadeSpace		;
	cmp	al,','			;
	jz	short WadeSpace		;
	dec	esi			; Point at last space char
	cmp	al,13			; check for end of line
	ret
WadeSpace	ENDP	
;
; Main Input routine
;
InputHandler	PROC	
	sti
	Msg	<10,13,"* ">		; MONITOR prompt
	call	GetInputLine		; Get an input line
	call	WadeSpace		; Wade through spaces
    jnz     docmd
    mov     byte ptr [si],13
    dec     si
    mov     al,[lastcmd]
    and     al,05fh
    or      al,20h
    cmp     al,'t'
    jz      docmd
    cmp     al,'p'
    jz      docmd
    cmp     al,'d'
    jz      docmd
    cmp     al,'u'
    jnz     InputHandler           ; blank line, so try again
docmd:
    mov     [lastcmd],al            ; 
	inc	esi			; Point at first non-space char
	mov	edi,offset DGROUP:Commands	; Get command list
	mov	ecx,comlen		; Length of list
	repne	scasb			;
	jnz	ierr			; Error if not in list
	mov	eax,comlen-1		; Calculate position
	sub	eax,ecx			;
	push	0			; command arg = 0
	call	TableDispatch		; Dispatch command
	dd	comlen-1
	dd	asm
	dd	breaks
	dd	compare
	dd	dump
	dd	entry
	dd	fill
	dd	go
	dd	domath
	dd	doin
	dd	move
	dd	doout
	dd	Proceed
	dd	_exit
	dd	ModifyRegisters
	dd	search
	dd	trap
	dd	diss
	dd	Help
	dd	slash
	jnc	InputHandler		; Get more input if no err
ierr:
	call	qerr			; Display error
	jmp	InputHandler		; Get more input
InputHandler	ENDP	
END