; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
; COMPARE.ASM
;
; Function: compare memory regions
;
	;MASM MODE
	.386
	.MODEL SMALL


include prints.ase 
include input.ase 
include mtrap.ase 

	PUBLIC	compare
	PUBLIC	paddr


	.CODE

;INPUT: AL has byte (two hex chars) to print

pbyte	PROC
	call	PrintByte
	call	PrintSpace
	ret
pbyte	ENDP

;INPUT: EDX has segment address
;	EAX has offset address
;If flat real mode, print 32-bit offset, else print 16-bit offset

paddr	PROC
	call	PrintDword		;print 32-bit offset
	call	PrintSpace
	ret
paddr	ENDP
;
; compare command
; syntax is c start,end,start2
;
compare	PROC
	call	WadeSpace		;find source address
	jz	errx			;not found (end of input)
	call	ReadAddress 			;start seg in DX, offset in EBX
	jc	errx			;not found
	call	WadeSpace		;see if any more
	jz	errx			;nope, didn't find
	call	ReadNumber		; read ending offset
	jc	errx			;not found
	mov	ecx,eax			;get ending offset into ECX
	sub	ecx,ebx			;subtract starting offset
	jb	errx			;error if end < start
	call	WadeSpace		;else keep reading input
	jz	errx			;need a destination
	mov	edx,ebx
	call	ReadAddress			; read dest seg and ofs
	jc	errx			;not found
	call	WadeSpace		;make sure no more
	jnz	errx			;if more, syntax error
gotsz:
	mov	esi,edx
	mov	edi,ebx
clp:
	repe	cmpsb			;cmp ds:[esi] with es:[edi]
	mov	al,ds:[esi-1]		;differing byte from source in AL
	mov	ah,es:[edi-1]		;and dest in AH
	jz	cdone			;no difference in this case
	push	ax			;save differing bytes
	call	crlf			;new line
	mov	eax,esi			;location where different
	dec	eax			;minus cmpsb moved ESI past it
	call	paddr			;show ESI where different
	pop	ax			;restore differing bytes
	push	ax			;and save them again
	call	pbyte			;show source byte
	pop	ax			;get them back
	mov	al,ah			;setup dest byte
	call	pbyte			;and show that
	mov	eax,edi			;get dest offset
	dec	eax			;minus correction for cmps
	call	paddr			;show dest seg:ofs
	jmp	clp			;find next difference
	
cdone:
	clc				; to clean up stack
	ret
errx:
	stc
	ret
compare	endp
end
