/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <bios.h>
#include <dpmi.h>

unsigned _RTL_FUNC _bios_timeofday(unsigned __cmd, long *__timeval)
{
   union REGS regs ;
   regs.h.ah = __cmd ;
   regs.w.cx = *__timeval >> 16 ;
   regs.w.dx = *__timeval ;
   _int386(0x12,&regs,&regs) ;
   *__timeval = (regs.w.cx << 16) + regs.w.dx ;
   return regs.w.ax ;
   
}
long _RTL_FUNC     biostime(int __cmd, long __newtime)
{
   _bios_timeofday(__cmd, &__newtime) ;
   return __newtime ;
}