/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <time.h>
#include <stdio.h>
#include <wchar.h>
#include <locale.h>
#include <errno.h>
#include "libp.h"
#include <dpmi.h>
#include "llp.h"

extern int __maxfiles;
static unsigned char inbuf[512];

extern FILE *_pstreams[] ;

FILE _istreams[3] = { 
   { 0, _F_READ | _F_LBUF | _F_TERM,0,0,512,inbuf,inbuf,"CON:",FILTOK },
   { 0, _F_WRIT | _F_LBUF | _F_TERM,1,0,0,0,0,"CON:",FILTOK },
   { 0, _F_WRIT | _F_LBUF | _F_TERM,2,0,0,0,0,"CON:",FILTOK }
} ;

#undef stdin
#undef stdout
#undef stderr

#define stdin (&_istreams[0])
#define stdout (&_istreams[1])
#define stderr (&_istreams[2])

FILE *_RTL_FUNC  __getStream(int stream)
{
      return _pstreams[stream] ;
}
void __ll_init(void)
{
   static int done ;
   if (!done) {
      _pstreams[0] = &_istreams[0];
      _pstreams[1] = &_istreams[1];
      _pstreams[2] = &_istreams[2];
      __maxfiles = 3;
      done = 1 ;
   }
}
