#include <math.h>
#include <limits.h>

int ilogbf(float val)
{
    if (val == 0.0)
        return FP_ILOGB0;
    if (isnan(val))
        return FP_ILOGBNAN;
    if (isinf(val))
        return INT_MAX;
    return (int)logbf(val);
}
int ilogbl(long double val)
{
    if (val == 0.0)
        return FP_ILOGB0;
    if (isnan(val))
        return FP_ILOGBNAN;
    if (isinf(val))
        return INT_MAX;
    return (int)logbl(val);
}
int ilogb(double val)
{
    if (val == 0.0)
        return FP_ILOGB0;
    if (isnan(val))
        return FP_ILOGBNAN;
    if (isinf(val))
        return INT_MAX;
    return (int)logb(val);
}
