#include <math.h>
long double hypotl(long double x, long double y)
{
    #pragma STDC FP_CONTRACT OFF
    long double result, logbw ;
    int ilogbw = 0;
    if (x == 0.f && y == 0.f)
        return 0.f;
    logbw = logbl(fmaxl(fabsl(x), fabsl(y)));
    if (isfinite(logbw)) {
        ilogbw = (int)logbw;
        x = scalbnl(x, -ilogbw);
        y = scalbnl(y, -ilogbw);
    }
    result = sqrtl(x * x + y * y);

    result = scalbnl(result, ilogbw);

    return result ;
}
float hypotf(float x, float y)
{
    return hypotl(x,y);
}
double hypot(double x, double y)
{
    return hypotl(x,y);
}