; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_CRTL_DLL
[export _round]
[export _roundf]
[export _roundl]
%endif
[global _round]
[global _roundf]
[global _roundl]
[global round]
SECTION _DATA CLASS=DATA USE32
nm	db	"round",0

two dd 2
SECTION _TEXT CLASS=CODE USE32
round:
    fld1
    fld st1
    fscale
    fxch
    popone ; input, *2
    fld st0
    frndint
    call checkinvalid
    jc xit1
    fsubp st1 ; input, possibly 0
    ftst
    fstsw ax
    sahf
    popone
    mov cl,0
    jnz nearest
    ftst
    fstsw ax
    sahf
    mov cl,8
    ja nearest
    mov cl,4
nearest:
    sub esp,4
	fnstcw	[esp]
	mov	ax,[esp]
	and	ah,0f3h
    or ah,cl
	mov	[esp+2],ax
	fldcw	[esp+2]
	frndint
    call checkinvalid
xit:
	fldcw	[esp]
    add esp,4
    ret
xit1:
    fxch
    popone
    jmp xit
_roundf:
	fld	dword[esp+4]
    sub dl,dl
    jmp short roundx
_roundl:
	fld	tword[esp+4]
    mov dl,2
    jmp short roundx
_round:
	fld	qword[esp+4]
    mov dl,1
roundx:    
    lea eax,[nm]
    call clearmath
    call round
    ret