; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef _BUILDING_LSCRTL_DLL
[export _remquo]
[export _remquof]
[export _remquol]
%endif
[global _remquo]
[global _remquof]
[global _remquol]
SECTION _DATA CLASS=DATA USE32
nm	db	"remquo",0

eight dd 8

SECTION _TEXT CLASS=CODE USE32
_remquof:
	lea	ecx,[esp+4]
	lea	edx,[esp+8]
	fld	dword[edx]
	fld	dword[ecx]
    mov ecx,[esp+12]
    sub dl,dl
    jmp short remquo
_remquol:
	lea	ecx,[esp+4]
	lea	edx,[esp+16]
	fld	tword[edx]
	fld	tword[ecx]
    mov ecx,[esp+28]
    mov dl,2
    jmp short remquo
_remquo:
	lea	ecx,[esp+4]
	lea	edx,[esp+12]
	fld	qword[edx]
	fld	qword[ecx]
    mov ecx,[esp+20]
    mov dl,1
remquo:
    lea eax,[nm]
    call clearmath
    fxch
    ftst
    fxch
    fnstsw ax
    sahf
    jz moderr
    fld st1
    fld st1
reprem:
	fprem1
    fstsw ax
    sahf
    jp reprem
    fxch
    popone
    fxch st2
    fdivp st1
    fild dword [eight]
    fld st1
reprem2:
    fprem1 
    fstsw ax
    sahf
    jp reprem2
    frndint
    fxch
    fcomp st1
    fxch
    ftst
    fstsw ax
    mov dh,ah
    fxch
    ftst
    fstsw ax
    fxch
    popone
    sahf
    jae noadjust
    fild dword [eight]
    faddp st1
noadjust:
    je noadj2
    mov ah,dh
    sahf
    jae noadj2
    fild dword [eight]
    fchs
    faddp st1
noadj2:
    fistp dword [ecx]    
    jmp wrapmath
moderr:
    popone
    jmp domainerr