; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _powf]
[export _pow]
[export _powl]
%endif
[global _powf]
[global _pow]
[global _powl]
[extern exp2]

SECTION _DATA CLASS=DATA USE32
nm	db	"pow",0

SECTION _TEXT CLASS=CODE USE32

_powf:
    fld dword [esp+8]
	fld	dword [esp+4]
    sub dl,dl
    jmp short pow
_powl:
    fld tword [esp+16]
	fld	tword [esp+4]
    mov dl,2
    jmp short pow
_pow:
    fld qword [esp+12] ; y
	fld	qword [esp+4]  ; x
    mov dl,1
pow:
    sub cl,cl
    lea eax,[nm]
    call clearmath
    fxam
    fstsw ax
    and ah,45h
    cmp ah,40h
    jz  zero
    fstsw ax
    test ah,2
    jz nonneg
    fld st1
    sub esp,4
    fnstcw	[esp]
	mov	ax,[esp]
	and	ah,0f3h
	or	ah,4
	mov	[esp+2],ax
	fldcw	[esp+2]
	frndint
	fldcw	[esp]
    add esp,4
    fsub st2
    ftst
    fstsw ax
    sahf
    jnz err
    popone
    fld st1
    sub esp,8
    fistp qword [esp]
    call checkinvalid
    jc err2
    mov cl,[esp] ; sign bit in cl
    fabs
    add esp,8    
nonneg:
    fyl2x
    fld1
    push ecx
    call exp2
    pop ecx
    test cl,1
    jz wrapmath
    fchs
    jmp wrapmath
zero:
    fxch
    popone
    jmp wrapmath
err2:
    add esp,8
    popone
    jmp domainerr
err:
    poptwo
    jmp domainerr
