; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _lround]
[export _lroundf]
[export _lroundl]
%endif
[global _lround]
[global _lroundf]
[global _lroundl]
[extern round]
SECTION _DATA CLASS=DATA USE32
nm	db	"lround",0


SECTION _TEXT CLASS=CODE USE32
_lroundf:
	fld	dword[esp+4]
    sub dl,dl
    jmp short lround
_lroundl:
	fld	tword[esp+4]
    mov dl,2
    jmp short lround
_lround:
	fld	qword[esp+4]
    mov dl,1
lround:    
    lea eax,[nm]
    call clearmath
    sub esp,12
    call round
    fistp dword [esp]
    call checkinvalid
    jc maxint
    mov eax,[esp]
    add esp,12
    ret
maxint:
    popone
    mov eax,07fffffffh
    add esp,12
    ret