; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _frexp]
[export _frexpf]
[export _frexpl]
%endif
[global _frexp]
[global _frexpf]
[global _frexpl]
SECTION _DATA CLASS=DATA USE32
nm	db	"frexp",0

SECTION _TEXT CLASS=CODE USE32

four	dw	4

_frexpf:
	lea	ecx,[esp+4]
	fld	dword[ecx]
	mov	ecx,[esp+8]
    sub dl,dl
    jmp short frexp
_frexpl:
	lea	ecx,[esp+4]
	fld	tword[ecx]
	mov	ecx,[esp+16]
    mov dl,2
    jmp short frexp
_frexp:
	lea	ecx,[esp+4]
	fld	qword[ecx]
	mov	ecx,[esp+12]
    mov dl,1
frexp:
    lea eax,[nm]
    call clearmath
    fldz
    fcomp   st1
    fstsw   ax
    sahf
    jz  zero
	fxtract
	fxch	st1
	fld1
	fadd	st1,st0
    faddp st1
    jmp join
zero:
    popone
    fldz
    fldz
join:
    fistp   dword[ecx]
	fild	word[four]
	fdivp	st1
    jmp wrapmath
