; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%ifdef __BUILDING_LSCRTL_DLL
[export _feclearexcept]
[export _fegetexceptflag]
[export _feraiseexcept]
[export _fesetexceptflag]
[export _fetestexcept]
%endif
[global _feclearexcept]
[global _fegetexceptflag]
[global _feraiseexcept]
[global _fesetexceptflag]
[global _fetestexcept]
[global feflagshold]
SECTION _DATA CLASS=DATA USE32

feflagshold dw    0
SECTION _TEXT CLASS=CODE USE32

_feclearexcept:
    mov ax,[esp+4]
    not ax
    or ax,0ff00h
    sub esp,28
    fnstenv [esp]
    and word [esp+4],ax
    fldenv [esp]
    add esp,28
    and [feflagshold],ax
    ret
_fegetexceptflag:
    fnstsw ax
    and ax, 0ffh
    and ax, word [esp+ 8]
    or  ax,[feflagshold]
    mov ecx, [esp+4]
    mov word [ecx],ax
    ret
_fesetexceptflag:
    mov ax,[esp+8]
    mov ecx,[esp+4]
    and ax,[ecx]
    and ax,0ffh
    mov [feflagshold],ax
    ret
_feraiseexcept:
    mov eax,[esp+4]
    and ax,0ffh
    sub esp,28
    fnstenv [esp]
    or word [esp+4],ax
    fldenv [esp]
    fwait
    add esp,28
    ret
_fetestexcept:
    fstsw ax
    and ax,[esp+4]
    and eax,0ffh
    or ax,[feflagshold]
    ret
