; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _cbrt]
[export _cbrtf]
[export _cbrtl]
%endif
[global _cbrt]
[global _cbrtf]
[global _cbrtl]
[extern exp2]
SECTION _DATA CLASS=DATA USE32
nm	db	"cbrt",0

oneoverthree   dt 0.33333333333333333
SECTION _TEXT CLASS=CODE USE32
_cbrtf:
	lea	ecx,[esp+4]
	fld	dword[ecx]
    sub dl,dl
    jmp short cbrt
_cbrtl:
	lea	ecx,[esp+4]
	fld	tword[ecx]
    mov dl,2
    jmp short cbrt
_cbrt:
	lea	ecx,[esp+4]
	fld	qword[ecx]
    mov dl,1
cbrt:
	lea	eax,[nm]
    call clearmath
    fxam
    fstsw ax
    mov al,ah
    and al,45h
    cmp al,40h
    jz retz
    fabs
    fld tword [oneoverthree]
    fxch
    fyl2x
    push eax
    fld1
    call exp2
    pop eax
    and ah,2h
    jz  wrapmath
    fchs
    jmp wrapmath
retz:
    popone
    fldz
    ret
