; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _acos]
[export _acosf]
[export _acosl]
%endif
[global _acos]
[global _acosf]
[global _acosl]

SECTION _DATA CLASS=DATA USE32
nm	db	"acos",0

SECTION _TEXT CLASS=CODE USE32
_acosf:
	lea	ecx,[esp+4]
	fld	dword[ecx]
    sub dl,dl
    jmp short acos
_acosl:
	lea	ecx,[esp+4]
	fld	tword[ecx]
    mov dl,2
    jmp short acos
_acos:
	lea	ecx,[esp+4]
	fld	qword[ecx]
    mov dl,1
acos:
    lea eax,[nm]
    call    clearmath
    fld st0
    fabs
    fld1
    fcompp
    fstsw ax
    sahf
    jb domainerr
	fld	st0
    fld st0
	fmulp	st1
	fld1
	fxch 	st1
	fsubp	st1,st0
	fsqrt
    fxch
	fdivp	st1,st0
	fld1
	fpatan
    fldz
    fcomp st1
    fstsw ax
    sahf
    jc nosub
    fldpi
    faddp st1
nosub:
	jmp	wrapmath
