/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <locale.h>
#include <wchar.h>
#include "io.h"
#include "libp.h"

extern int _abterm;
extern int __maxfiles;
extern FILE *_pstreams[_NFILE_];

static struct _rmvlist {
    struct _rmvlist *next;
    char *name;
} *remove_list;
/* must happen before fcloseall */
#pragma rundown __removealltemps 51

int __insertTempName(char *name)
{
    struct _rmvlist *rmv;
    char *aa = strdup(name);
    if (!aa)
        return 1;
    rmv = malloc(sizeof(struct _rmvlist));
    if (!rmv) {
        free(aa);
        return 1;
    }   
    __ll_enter_critical();
    rmv->next = remove_list;
    rmv->name = aa ;
    remove_list = rmv ;
    __ll_exit_critical();
    return 0;
}
static int __removeTempFiles(void)
{
	int count = 0;
    while (remove_list) {
        struct _rmvlist *next = remove_list->next ;
        unlink(remove_list->name);
        free(remove_list->name);
        free(remove_list);
        remove_list = next;
		count ++;
    }
	return count;
}
static void __closeTempFiles(void)
{
	struct _rmvlist *rmv = remove_list;
    while (rmv) {
		int i;
		for (i= __maxfiles-1; i >=3; i--)
		{
			if (!strcmp(_pstreams[i]->name, rmv->name))
			{
				fclose(_pstreams[i]);
				break;
			}
		}
        rmv = rmv->next;
    }
}
int _RTL_FUNC rmtmp(void)
{
	__closeTempFiles();
	return __removeTempFiles();
}
int _RTL_FUNC _rmtmp(void)
{
	return rmtmp();
}
void __removealltemps(void)
{
   if (!_abterm) {
      __removeTempFiles();
   }
}
