/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <errno.h>
#include <string.h>

int _RTL_FUNC (ungetc)(int c, FILE *stream)
{
	if (stream->token != FILTOK) {
		errno = _dos_errno = ENOENT;
		return EOF;
	}
    if (stream->orient == __or_wide) {
        errno = EINVAL;
        return EOF;
    }
    stream->orient = __or_narrow;
    stream->flags &= ~_F_VBUF;
    if (c == EOF)
        return EOF;
	if (stream->flags & _F_UNGETC) {
		errno = _dos_errno = ENOSPC;
		return EOF;
	}
	stream->hold = (char)c;
    stream->flags &= ~_F_EOF;
	stream->flags |= _F_UNGETC;
	return c;
}
int _RTL_FUNC _ungetc(int c, FILE *stream)
{
	return ungetc(c, stream);
}