/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <wchar.h>
#include <locale.h>
#include <dir.h>
#include "libp.h"

char *_RTL_FUNC tmpnam(char *buf)
{
	int n = 0;
    if (!buf)
        buf = &__getRtlData()->tmpfilnam;
    __ll_enter_critical();
	do
	{
		sprintf(buf, "tmp%05d.$$$", n++);
	}
	while (!access(buf, 0) && n <= TMP_MAX);
    __ll_exit_critical();
	if (n <= TMP_MAX)
		return buf;
	return NULL;		
}
char *_RTL_FUNC tempnam(char *dir, char *prefix)
{
	int n = 0;
	char buf[MAXPATH], *p;
	char *s = getenv("TMP");
	struct ffblk ff;
	if (!s || findfirst(s, &ff, 0xff))
	{
		s = dir;
		if (!s || findfirst(s, &ff, 0xff))
		{
			s = buf;
			buf[0] = 0;
		}
	}
	strcpy(buf, s);
	s = buf;
	p = s + strlen(s);
	if (p != s && p[-1] != '\\')
		*p++ = '\\';
    __ll_enter_critical();
	do
	{
		sprintf(p, "%s%05d", prefix, n++);
	}
	while (!access(buf, 0) && n <= TMP_MAX);
    __ll_exit_critical();
	if (n <= TMP_MAX)
		return strdup(buf);	
	return NULL;
}
char *_RTL_FUNC _tempnam(char *dir, char *prefix)
{
	return tempnam(dir, prefix);
}
FILE *_RTL_FUNC tmpfile(void)
{
	char *aa;
	FILE *rv;
    int len;
	
	aa = tempnam(NULL, "tmf");
    if (__insertTempName(aa))
	{
		free(aa);
        return 0;
	}
	rv = fopen(aa,"wb+");
	free(aa);
	return rv;
}
